 ; Ŀ
 ;   Dak - remove xdata from selected entities.                            
 ;   Copyright 2002, 2006 by Rocket Software Ltd.                          
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Marf - mark all points in an entity data list.             
 ;   Arguments: Enam, an entity name.                                      
 ;              Radd, a radius.                                            
 ;              Colo, a colour number.                                     
 ;   Calls Ci, returns nothing.                                            
 ; 
 (DEFUN MARF (enam radd colo / entt num sub)
  (setq entt (entget enam))
  (setq num 0)
  (while (setq sub (nth num entt))
         (setq num (1+ num))
         (if (and (= (type (cdr sub)) 'list)
                  (= (length sub) 4)
                  (not (equal (cdr sub) '(0 0 0))))
             (ci (cdr sub) radd colo)))
 (princ))
 ; Ŀ
 ;   Marf end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine CI - grdraw circle maker.                                  
 ; 
 (DEFUN CI (pa radd colo / reps pa pa1 pa2 angg)
  (setq reps 32)
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (setq pa1 (polar pa angg radd))
  (repeat reps
          (setq angg (+ angg incr))
          (setq pa2 (polar pa angg radd))
          (grdraw pa1 pa2 colo)
          (setq pa1 pa2))
 (princ))
 ; Ŀ
 ;   Ci end.                                                               
 ; 

 ; Ŀ
 ;   Exkill - remove the extended data from an entity.                     
 ;   Amazingly, this works: remove everything from the xdata for the       
 ;   app in question except the app name, entmod it back in, acad          
 ;   ditches the entire app xdata set from that entity.                    
 ;   Completely removing the xdata for that app doesn't work - acad        
 ;   assumes that it isn't touching the xdata for that app at all.         
 ;                                                                         
 ;   Arguments: Enam - the entity name.                                    
 ;              Appi - the application for which to remove the data.       
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN EXKILL (enam appi / entt exdat sub nuex)
  (setq entt (entget enam (list "*")))
  (if (setq exdat (assoc -3 entt))
      (progn
           (while (setq sub (car exdat))
                  (setq exdat (cdr exdat))
                  (if (and (= (type sub) 'LIST)
                           (= (car sub) appi))
                      (setq nuex (append nuex (list (list (car sub)))))
                      (setq nuex (append nuex (list sub)))))
           (entmod (append (entget enam) (list nuex)))))
 (princ))
 ; Ŀ
 ;   Exkill end.                                                           
 ; 

 ; Ŀ
 ;   Alap - return a list of all applications having xdata attached to     
 ;   a given entity.                                                       
 ;   Takes one argument, an ename.                                         
 ;   Returns a list of strings.                                            
 ; 
 (DEFUN ALAP (enam / bb exdat sub applst)
  (setq bb (entget enam (list "*")))
  (if (setq exdat (assoc -3 bb))
      (progn
           (setq exdat (cdr exdat))
           (while (setq sub (car exdat))
                  (setq exdat (cdr exdat))
                  (setq applst (cons (car sub) applst)))))
 applst)
 ; Ŀ
 ;   Alap end.                                                             
 ; 

 ; Ŀ
 ;   Dak.                                                                  
 ; 
 (DEFUN C:DAK (/ rad ss num enam exlist radd colo exanm)
  (setq rad (/ (getvar "viewsize") 45))
 ; Ŀ
 ;   Get an ss of entities with xdata, remove it from them.                
 ; 
  (prompt "\nSelect entities from which to remove xdata.")
  (setq ss (ssget (list (list -3 (list "*")))))
  (setq num 0)
 ; Ŀ
 ;   For each entity in the ss...                                          
 ; 
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
 ; Ŀ
 ;   Get a list of xdata app names.                                        
 ; 
         (setq exlist (alap enam))
         (setq radd rad)
         (setq colo 50)
 ; Ŀ
 ;   Call exkill to remove the data for each application.                  
 ; 
         (while (setq exanm (car exlist))
                (setq exlist (cdr exlist))
                (marf enam radd colo)
                (setq radd (* 1.25 radd))
                (setq colo (1+ colo))
                (exkill enam exanm)))
 (princ))